package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.SourceDTO;
import gov.va.genisis2.model.Source;

/**
 * This class is used to convert SourceDTO to Source entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class SourceConverter implements Converter<Source, SourceDTO> {

	@Override
	public SourceDTO convert(Source source) {
		SourceDTO sourceDto = new SourceDTO();

		sourceDto.setId(source.getId());
		sourceDto.setDescription(source.getDescription());

		return sourceDto;
	}

	public Source convert(SourceDTO sourceDto) {
		Source source = new Source();

		source.setId(sourceDto.getId());
		source.setDescription(sourceDto.getDescription());

		return source;
	}
	
	public List<SourceDTO> convertSources(List<Source> sources) {
		List<SourceDTO> sourcesDtos = null;
		if (!sources.isEmpty()) {
			sourcesDtos = new ArrayList<>();
			for (Source source : sources) {
				sourcesDtos.add(convert(source));
			}
		}
		
		return sourcesDtos;
	}
}
